
%% Matlab Code for generating breath noise in the range of -10 to 10 dB in steps of 1 dB and 201 test signals for each SNR
clc;
close all;
%% Load healthy person sound file here
load posterior_right
Healthy_person_sound    = data(1:end);
%% Load 10 identical simulated Cohen coarse crackles here 
load SC1_Cohen
load SC2_Cohen
load SC3_Cohen
load SC4_Cohen
load SC5_Cohen
load SC6_Cohen
load SC7_Cohen
load SC8_Cohen
load SC9_Cohen
load SC10_Cohen
fs              = 44100;                                                      %% Sampling frequency
Signal_length   = 32768;                                                      %% Signal length
%% Make the length equal
SC1_Cohen       = [zeros(1,1000),SC1_Cohen,zeros(1,Signal_length-(1000+length(SC1_Cohen)))];
SC2_Cohen       = [zeros(1,3000),SC2_Cohen,zeros(1,Signal_length-(3000+length(SC2_Cohen)))];
SC3_Cohen       = [zeros(1,7000),SC3_Cohen,zeros(1,Signal_length-(7000+length(SC3_Cohen)))];
SC4_Cohen       = [zeros(1,12000),SC4_Cohen,zeros(1,Signal_length-(12000+length(SC4_Cohen)))];
SC5_Cohen       = [zeros(1,14000),SC5_Cohen,zeros(1,Signal_length-(14000+length(SC5_Cohen)))];
SC6_Cohen       = [zeros(1,17000),SC6_Cohen,zeros(1,Signal_length-(17000+length(SC6_Cohen)))];
SC7_Cohen       = [zeros(1,20000),SC7_Cohen,zeros(1,Signal_length-(20000+length(SC7_Cohen)))];
SC8_Cohen       = [zeros(1,23000),SC8_Cohen,zeros(1,Signal_length-(23000+length(SC8_Cohen)))];
SC9_Cohen       = [zeros(1,27500),SC9_Cohen,zeros(1,Signal_length-(27500+length(SC9_Cohen)))];
SC10_Cohen      = [zeros(1,30000),SC10_Cohen,zeros(1,Signal_length-(30000+length(SC10_Cohen)))];
Ten_identical_simulated_Cohen_coarse_crackles       = SC1_Cohen+SC2_Cohen+SC3_Cohen+SC4_Cohen+SC5_Cohen+SC6_Cohen+SC7_Cohen+SC8_Cohen+SC9_Cohen+SC10_Cohen;
Ten_identical_simulated_Cohen_coarse_crackles       = Ten_identical_simulated_Cohen_coarse_crackles(1:end);
%% Preallocate variables here


%% Start SNR and Iterative loops
for SNR_loop        = -10:1:10                                              %% Start signal to noise ratio loop
for iterative_loop  = 1:201                                                 %% Start number of iterations loop 
%% Autoregressive model to generate breath noise
[p,e]               = armcov(data, 10);                                     %% Autoregressive model for generating breath noise
breath_noise        = filter(1,p,randn(1,Signal_length)); 
%% Calculate scaling factor for changing the signal to noise ratio
Crackle_power       = sum(abs(Ten_identical_simulated_Cohen_coarse_crackles).*abs(Ten_identical_simulated_Cohen_coarse_crackles))/Signal_length;                          
Noise_Power         = sum(abs(breath_noise).*abs(breath_noise))/Signal_length;
Scaling_factor      = (Crackle_power/Noise_Power)*10^(-SNR_loop/10);  
Signal              = sqrt(Scaling_factor)*breath_noise+Ten_identical_simulated_Cohen_coarse_crackles;   %% Signal with 10 identical Cohen coarse crackles buried under breath noise

%% Use your separation technique here


end
end